package ftp;
import java.io.File;
import java.io.PrintStream;

public class CommandeUSER extends Commande {

	private File[] repertoryUserContent = CommandExecutor.homeDir.listFiles();

	public CommandeUSER(PrintStream ps, String commandeStr) {
		super(ps, commandeStr);
	}

	@Override
	public void execute() {
		
		// Indique si un utilisateur est trouvé (true) ou non (false).
		boolean user = false;

		// Pour chaque fichier enfant du répertoire 'homeDir' (au début = 'src/user')
		for(File f : repertoryUserContent) {
			
			// Si le nom correspond au nom d'utilisateur rentré dans la commande.
			if(f.getName().equals(commandeArgs[0])) {
				user = true;
				
				// Mise à jour des variables de CommandExecutor.
				CommandExecutor.user = commandeArgs[0];
				CommandExecutor.homeDir = f;
				CommandExecutor.currentFile = f;
				break;
			}
		}
		
		// Envoi d'un message de confirmation si user est true ou d'erreur si user est false.
		if(user) {
			CommandExecutor.userOk = true;
			ps.println("0 Commande user OK");
		}
		else {
			ps.println("2 Le user " + commandeArgs[0] + " n'existe pas");
		}

	}

}